/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.PlantUML;
import com.gitlab.srcmc.rctmod.commands.arguments.TokenArgumentType;
import com.gitlab.srcmc.rctmod.commands.utils.SuggestionUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class PlayerCommands {
    private PlayerCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rctmod").requires(css -> css.method_9259(1))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"luck").executes(PlayerCommands::player_get_luck)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_luck_target)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"series").executes(PlayerCommands::player_get_current_series)).then(class_2170.method_9247((String)"completed").executes(PlayerCommands::player_get_completed_series))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_current_series_target)).then(class_2170.method_9247((String)"completed").executes(PlayerCommands::player_get_completed_series_target))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"progress").executes(PlayerCommands::player_get_progress)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"graph").executes(PlayerCommands::player_get_progress_graph)).then(class_2170.method_9244((String)"graph_flags", (ArgumentType)StringArgumentType.greedyString()).suggests(SuggestionUtils::get_graph_flag_suggestions).executes(PlayerCommands::player_get_progress_graph)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_progress_target)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"graph").executes(PlayerCommands::player_get_progress_graph)).then(class_2170.method_9244((String)"graph_flags", (ArgumentType)StringArgumentType.greedyString()).suggests(SuggestionUtils::get_graph_flag_suggestions).executes(PlayerCommands::player_get_progress_graph_target)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level_cap").executes(PlayerCommands::player_get_level_cap)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_level_cap_target)))).then(class_2170.method_9247((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(PlayerCommands::player_get_defeats)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_defeats_target))))).then(class_2170.method_9247((String)"type_defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_type_suggestions).executes(PlayerCommands::player_get_type_defeats)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_type_defeats_target)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(css -> css.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"progress").then(class_2170.method_9247((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_before)))).then(class_2170.method_9247((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_after)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_targets_before)))).then(class_2170.method_9247((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_targets_after))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(css -> css.method_9259(2))).then(class_2170.method_9247((String)"series").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"seriesId", (ArgumentType)TokenArgumentType.token()).suggests(SuggestionUtils::get_series_suggestions).executes(PlayerCommands::player_set_current_series)).then(class_2170.method_9247((String)"completed").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_completed_series)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(PlayerCommands::player_set_current_series_targets)).then(class_2170.method_9247((String)"completed").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_completed_series_targets))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"progress").then(class_2170.method_9247((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_before)))).then(class_2170.method_9247((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_after)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_targets_before)))).then(class_2170.method_9247((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_targets_after)))))).then(class_2170.method_9247((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)TokenArgumentType.token()).suggests(SuggestionUtils::get_trainer_suggestions_bulk).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_value))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_targets_value))))))));
    }

    private static int player_get_luck(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String bsw = PlayerCommands.getluck(player);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)bsw), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_luck_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        String bsw = PlayerCommands.getluck((class_1657)player);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)bsw), false);
        return 0;
    }

    private static String getluck(class_1657 player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        return String.format("%d/%.4f", tpd.getCompletedSeries().entrySet().stream().map(e -> sm.getGraph((String)e.getKey()).getMetaData().difficulty() * (Integer)e.getValue()).reduce(0, (a, b) -> a + b), Float.valueOf(tpd.getBonusLuck((int)(player.method_7292() * 10.0f))));
    }

    private static int player_get_current_series_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)PlayerState.get((class_1657)player).getCurrentSeries()), false);
        return 0;
    }

    public static int player_get_current_series(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)PlayerState.get(player).getCurrentSeries()), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_completed_series(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            Map.Entry<String, Integer> e;
            class_1657 player = (class_1657)class_12972;
            Iterator<Map.Entry<String, Integer>> it = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (it.hasNext()) {
                e = it.next();
                sb.append(e.getKey()).append(':').append(e.getValue());
            }
            while (it.hasNext()) {
                e = it.next();
                sb.append(", ").append(e.getKey()).append(':').append(e.getValue());
            }
            sb.append(']');
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(sb.toString())), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_completed_series_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        Map.Entry<String, Integer> e;
        class_3222 player = class_2186.method_9315(context, (String)"target");
        Iterator<Map.Entry<String, Integer>> it = RCTMod.getInstance().getTrainerManager().getData((class_1657)player).getCompletedSeries().entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            e = it.next();
            sb.append(e.getKey()).append(':').append(e.getValue());
        }
        while (it.hasNext()) {
            e = it.next();
            sb.append(", ").append(e.getKey()).append(':').append(e.getValue());
        }
        sb.append(']');
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int player_get_progress(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            Iterator it = RCTMod.getInstance().getTrainerManager().getData(player).getDefeatedTrainerIds().stream().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (it.hasNext()) {
                sb.append((String)it.next());
            }
            while (it.hasNext()) {
                sb.append(", ").append((String)it.next());
            }
            sb.append(']');
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(sb.toString())), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_progress_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        Iterator it = RCTMod.getInstance().getTrainerManager().getData((class_1657)player).getDefeatedTrainerIds().stream().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            sb.append((String)it.next());
        }
        while (it.hasNext()) {
            sb.append(", ").append((String)it.next());
        }
        sb.append(']');
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int player_get_progress_graph(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            PlayerCommands.get_progress_graph(context, player);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_progress_graph_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerCommands.get_progress_graph(context, (class_1657)class_2186.method_9315(context, (String)"target"));
        return 0;
    }

    private static void get_progress_graph(CommandContext<class_2168> context, class_1657 player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        String flagStr = "";
        int flags = 0;
        try {
            flagStr = StringArgumentType.getString(context, (String)"graph_flags");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!flagStr.isEmpty()) {
            flags = SuggestionUtils.getGraphFlags(flagStr);
        }
        boolean includeDefeated = (flags & SuggestionUtils.GF_INCLUDE_DEFEATED) != 0;
        boolean includeOptionals = (flags & SuggestionUtils.GF_INCLUDE_OPTIONALS) != 0;
        boolean includeSingles = (flags & SuggestionUtils.GF_INCLUDE_SINGLES) != 0;
        SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(tpd.getCurrentSeries());
        String url = "https://www.plantuml.com/plantuml/svg/" + PlantUML.encode(includeDefeated ? graph.getRemaining(includeOptionals, includeSingles) : graph.getRemaining(tpd.getDefeatedTrainerIds(), includeOptionals, includeSingles), tpd.getDefeatedTrainerIds());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("%s's series progression graph (%s): ", player.method_5476().getString(), graph.getMetaData().title())).method_10852((class_2561)class_2561.method_43470((String)url).method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1073, class_124.field_1060}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click on the link to open the graph in your browser"))).method_10958(new class_2558(class_2558.class_2559.field_11749, url)))), false);
    }

    private static int player_get_level_cap(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            int level_cap = RCTMod.getInstance().getTrainerManager().getData(player).getLevelCap();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(level_cap)), false);
            return level_cap;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_level_cap_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        int level_cap = RCTMod.getInstance().getTrainerManager().getData((class_1657)player).getLevelCap();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(level_cap)), false);
        return level_cap;
    }

    private static int player_get_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = PlayerState.get(player).getTrainerDefeatCount(trainerId);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
                return count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_get_defeats_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            class_3222 player = class_2186.method_9315(context, (String)"target");
            int count = PlayerState.get((class_1657)player).getTrainerDefeatCount(trainerId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
            return count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }

    private static int player_get_type_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                TrainerType type = TrainerType.valueOf((String)context.getArgument("type", String.class));
                long count = PlayerState.get(player).getTypeDefeatCount(type);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
                return (int)count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_get_type_defeats_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            TrainerType type = TrainerType.valueOf((String)context.getArgument("type", String.class));
            class_3222 player = class_2186.method_9315(context, (String)"target");
            long count = PlayerState.get((class_1657)player).getTypeDefeatCount(type);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
            return (int)count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }

    private static int player_set_completed_series(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String seriesid = StringArgumentType.getString(context, (String)"seriesId");
            if (seriesid.equals("empty")) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"cannot complete empty series"));
                return -1;
            }
            int count = IntegerArgumentType.getInteger(context, (String)"count");
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
            Integer current = tpd.getCompletedSeries().getOrDefault(seriesid, 0);
            tpd.addSeriesCompletion(seriesid, count - current);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_set_completed_series_targets(CommandContext<class_2168> context) throws CommandSyntaxException {
        String seriesid = StringArgumentType.getString(context, (String)"seriesId");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        if (seriesid.equals("empty")) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"cannot complete empty series"));
            return -1;
        }
        for (class_3222 player : class_2186.method_9312(context, (String)"targets")) {
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((class_1657)player);
            Integer current = tpd.getCompletedSeries().getOrDefault(seriesid, 0);
            tpd.addSeriesCompletion(seriesid, count - current);
        }
        return 0;
    }

    private static int player_set_current_series(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String seriesid = StringArgumentType.getString(context, (String)"seriesId");
            seriesid = seriesid.equals("empty") ? "" : seriesid;
            RCTMod.getInstance().getTrainerManager().getData(player).setCurrentSeries(seriesid);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_set_current_series_targets(CommandContext<class_2168> context) throws CommandSyntaxException {
        String seriesid = StringArgumentType.getString(context, (String)"seriesId");
        seriesid = seriesid.equals("empty") ? "" : seriesid;
        for (class_3222 player : class_2186.method_9312(context, (String)"targets")) {
            RCTMod.getInstance().getTrainerManager().getData((class_1657)player).setCurrentSeries(seriesid);
        }
        return 0;
    }

    private static int player_set_progress_before(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                tpd.removeProgressDefeats();
                HashSet visited = new HashSet();
                tmd.getMissingRequirements(Set.of()).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_add_progress_before(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                HashSet visited = new HashSet();
                tmd.getMissingRequirements(Set.of()).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_set_progress_after(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                tpd.removeProgressDefeats();
                PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_add_progress_after(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_set_progress_targets_before(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (class_3222 player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((class_1657)player);
            tpd.removeProgressDefeats();
            HashSet visited = new HashSet();
            tmd.getMissingRequirements(Set.of()).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
        }
        return 0;
    }

    private static int player_add_progress_targets_before(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (class_3222 player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((class_1657)player);
            HashSet visited = new HashSet();
            tmd.getMissingRequirements(Set.of()).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
        }
        return 0;
    }

    private static int player_set_progress_targets_after(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (class_3222 player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((class_1657)player);
            tpd.removeProgressDefeats();
            PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
        }
        return 0;
    }

    private static int player_add_progress_targets_after(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (class_3222 player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((class_1657)player);
            PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
        }
        return 0;
    }

    private static int player_set_defeats_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = IntegerArgumentType.getInteger(context, (String)"value");
                TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                class_3218 level = (class_3218)player.method_37908();
                if (!SuggestionUtils.executeBulk(trainerId, data -> data.map(e -> (String)e.getKey()).forEach(tid -> tm.getBattleMemory(level, (String)tid).setDefeatedBy((String)tid, player, count)))) {
                    tm.getBattleMemory(level, trainerId).setDefeatedBy(trainerId, player, count);
                }
                return count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_set_defeats_targets_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            Collection targets = class_2186.method_9312(context, (String)"targets");
            int count = IntegerArgumentType.getInteger(context, (String)"value");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            boolean bulk = SuggestionUtils.executeBulk(trainerId, data -> {
                for (class_3222 player : targets) {
                    class_3218 level = (class_3218)player.method_37908();
                    data.map(e -> (String)e.getKey()).forEach(tid -> tm.getBattleMemory(level, (String)tid).setDefeatedBy((String)tid, (class_1657)player, count));
                }
            });
            if (!bulk) {
                for (class_3222 player : targets) {
                    class_3218 level = (class_3218)player.method_37908();
                    tm.getBattleMemory(level, trainerId).setDefeatedBy(trainerId, (class_1657)player, count);
                }
            }
            return count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }

    private static void add_progress(TrainerPlayerData tpd, String trainerId, Set<String> visited) {
        if (!visited.contains(trainerId)) {
            visited.add(trainerId);
            TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId);
            tmd.getMissingRequirements(Set.of()).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            tpd.addProgressDefeat(trainerId);
        }
    }
}

